// SimpleCoordMotion.cpp : Defines the entry point for the console application.
//


#include "stdafx.h"
#include "CoordMotion.h"

// Global Variables

CCoordMotion CM;


int main(int argc, char* argv[])
{
	MOTION_PARAMS *p=CM.GetMotionParams();

	CM.m_board=0;

	p->BreakAngle = 30;
	p->MaxAccelX = 1;
	p->MaxAccelY = 1;
	p->MaxAccelZ = 1;
	p->MaxAccelA = 1;
	p->MaxVelX = 1;
	p->MaxVelY = 1;
	p->MaxVelZ = 1;
	p->MaxVelA = 1;
	p->CountsPerInchX = 100;
	p->CountsPerInchY = 100;
	p->CountsPerInchZ = 100;
	p->CountsPerInchA = 100;
	

	double Speed = 0.5; //inch/sec

	CM.StraightTraverse(0.0000, 0.0000, 0.0000, 0.0000);  // jump back to zero
    
	// set a bit, move in a circle, clear a bit

	CM.DoKMotionBufCmd("SetBitBuf0");
    CM.ArcFeed(Speed,0.0000, 0.5000, 0.0000, 0.2500, DIR_CCW, 0.0000);
    CM.ArcFeed(Speed,0.0000, 0.0000, 0.0000, 0.2500, DIR_CCW, 0.0000);
	CM.DoKMotionBufCmd("ClearBitBuf0");
	
	// move in an xy square (0,0) -> (0,0.5) -> (0.5,0.5) -> (0.5,0) -> (0,0)

	CM.StraightFeed(Speed, 0.0, 0.5, 0.0, 0.0);
	CM.StraightFeed(Speed, 0.5, 0.5, 0.0, 0.0);
	CM.StraightFeed(Speed, 0.5, 0.0, 0.0, 0.0);
	CM.StraightFeed(Speed, 0.0, 0.0, 0.0, 0.0);

	// turn on a bit, wait 2 seconds, turn the bit off

	CM.DoKMotionBufCmd("SetBitBuf0");
	CM.Dwell(2);
	CM.DoKMotionBufCmd("ClearBitBuf0");
	CM.FlushSegments();
	return 0;
}

